<?php

class AntrianController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
				return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','create','chat'
					),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('index','Panggil','Panggilulang','Adminkolektif','admin'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete','Panggil','Panggilulang'),
				'users'=>array('administrator'),
			),
			array('allow', // allow admin user to perform ‘admin’ and ‘delete’ actions
			'actions'=>array('admin','create','delete','update'),
			'expression'=>'Yii::app()->user->isSuperadmin()',
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */

	public function actionChat()
	{
		$this->layout=false;
		$this->render('chat');
	}
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}


	public function actionPanggil()
	{
		$text="";

		$min = Yii::app()->db->createCommand("SELECT antrian.id,
		antrian.id_jenis,
		antrian.nomor AS minnom,
		loket.nama_loket,
		loket.inisial

 		FROM antrian 
		INNER JOIN loket ON antrian.id_jenis = loket.id
 		where antrian.id_jenis='".Yii::app()->user->loket."' and antrian.nomor =( SELECT MIN(antrian.nomor) FROM antrian where status ='waiting' and id_jenis='".Yii::app()->user->loket."')")->queryRow();

		if(!empty($min['id']))
		{
			Yii::app()->db->createCommand("update antrian set status='finish',pemanggil='".Yii::app()->user->usernamex."' where id= '".$min['id']."'")->query();

			

			$text="Nomor antrian ".$min['inisial'].$min['minnom']. " menuju ".$min['nama_loket'];
		}
			$this->redirect(array('Admin','text'=>$text));
		
	}

	public function actionPanggilulang($id,$id_jenis,$nomor)
	{

	
		$text="";
		$min = Yii::app()->db->createCommand("SELECT inisial,nama_loket from loket where id='".$id_jenis."'")->queryRow();

		if($id && $id_jenis && $nomor)
		{
			Yii::app()->db->createCommand("update antrian set status='finish',pemanggil='".Yii::app()->user->usernamex."' where id= '".$id."'")->query();

			

			
		}

		$text="Nomor antrian ".$min['inisial'].$nomor. " menuju ".$min['nama_loket'];
		$this->redirect(array('Admin','text'=>$text));
		
	}


	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate($id_jenis)
	{	
		Yii::app()->db->createCommand("DELETE FROM antrian where date(tanggal) <> date(CURRENT_DATE)")->execute();
		$this->layout=false;
		$max = Yii::app()->db->createCommand("SELECT coalesce(MAX(nomor), 0)+ 1 as maxnom FROM antrian  where id_jenis=".$id_jenis." ")->queryRow();
		//$count=Yii::app()->db->createCommand("select count(id )as jumlah from antrian")->queryRow();
		
		$customer = new Antrian();
		$customer->nomor = $max['maxnom'];
		$customer->id_jenis = $id_jenis;
		$customer->status = 'waiting';
		$customer->tanggal = date('Y-m-d H:i:s');
		$customer->save();
		
		$this->render('print',array(
			'id'=>$customer->id,
		));
		//$this->redirect(array('loket/index'));
	
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$this->layout='admin';
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Antrian']))
		{
			$model->attributes=$_POST['Antrian'];
			if($model->save())
				$this->redirect(array('admin'));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->layout='admin';
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex($id=false)
	{
		$criteria = new CDbCriteria();
		//if($id)
		//{
        //$criteria->addCondition("id_kategori =$id");
    	//}
        $criteria->order = 'id DESC';
		$jumlah =Antrian::model()->count($criteria); 
		$halaman = new CPagination($jumlah); 
		$halaman->pageSize=20; 
		$halaman->applyLimit($criteria);
		$total=$jumlah;
		$data = Antrian::model()->findAll($criteria); 
		
		$this->render('index', array('halaman'=>$halaman, 'data'=>$data,'total'=>$total  ));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin($id=false,$text=false)
	{
		$this->layout='admin';
		//	$this->layout='MAIN';
		//if($id)
		//{
        
    	//}
		$criteria = new CDbCriteria();
		$criteria->addCondition("id_jenis =".Yii::app()->user->loket);
        $criteria->order = 'id DESC';
		$jumlah =Antrian::model()->count($criteria); 
		$halaman = new CPagination($jumlah); 
		$halaman->pageSize=10; 
		$halaman->applyLimit($criteria);
		$total=$jumlah;
		$data = Antrian::model()->findAll($criteria); 
		
		$this->render('admin', array('halaman'=>$halaman, 'data'=>$data,'total'=>$total,'text'=>$text  ));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Antrian the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Antrian::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Antrian $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='antrian-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
