<?php

class UserController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	//public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			//'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('create','captcha'
					),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('index'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('administrator'),
			),
			array('allow', // allow admin user to perform ‘admin’ and ‘delete’ actions
			'actions'=>array('admin','create','delete','update','view'),
			'expression'=>'Yii::app()->user->isSuperadmin()',
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}


	//<!--captcha-->
    public function actions()
    {
         return array(
            'captcha'=>array(
                'class'=>'CCaptchaAction',
                'backColor'=>0xFFFFFF,
           ),
         );
    }//<!--captcha-->
    
	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->layout='admin';
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{//$this->layout='admin';
		  $model=new User('passwordset'); //scenario passwordset digunakan pada rules() di model User.php seperti 'on'=>'passwordset'
   // Uncomment the following line if AJAX validation is needed
   // $this->performAjaxValidation($model);
   if(isset($_POST['User']))
   {
     $model->attributes=$_POST['User'];
     if($model->save())
        $this->redirect(array('user/admin'));
   }
   $this->render('create',array(
     'model'=>$model,
   ));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{//$this->layout='admin';
		 $model=$this->loadModel($id);
  // Uncomment the following line if AJAX validation is needed
  // $this->performAjaxValidation($model);
  if(isset($_POST['User']))
   {
     $model->attributes=$_POST['User'];
 
     // We only want to apply the scenario when a password field has been entered,
     // so set the scenario on the model conditionally. 
     if ($model->password || $model->password_repeat)
       $model->scenario = 'passwordset';
 
     if($model->save())
       $this->redirect(array('admin'));
   }
  $this->render('update',array(
   'model'=>$model,
  ));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{//$this->layout='admin';
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{  
		$this->layout='admin';
		$criteria = new CDbCriteria();
        $criteria->order = 'id DESC';

		$jumlah = User::model()->count($criteria); 

		$halaman = new CPagination($jumlah); 

		$halaman->pageSize=10; 

		$halaman->applyLimit($criteria);
		$total=$jumlah;
		$data = User::model()->findAll($criteria); 

		$this->render('admin', array('halaman'=>$halaman, 'data'=>$data,'total'=>$total ));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return User the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=User::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param User $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='user-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
