<?php

/**
 * This is the model class for table "user".
 *
 * The followings are the available columns in table 'user':
 * @property string $id
 * @property string $username
 * @property string $pwd_hash
 * @property integer $level
 */
class User extends CActiveRecord
{public $password;
 public $password_repeat;
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user';
	}
	//CCaptchaAction
 //  	public $verifyCode;
   	//CCaptchaAction

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		 // NOTE: you should only define rules for those attributes that
 // will receive user inputs.
 return array(
 		//array('verifyCode','captcha','allowEmpty'=>!CCaptcha::checkRequirements()),
 array('username,loket', 'required'),
 array('username', 'unique'),
 array('username', 'length', 'min'=>3, 'max'=>40),
  array('loket', 'length', 'min'=>1, 'max'=>5),
 
 array('password, password_repeat', 'required', 'on' => 'passwordset'),
 array('password', 'length', 'min'=>8, 'max'=>40, 'on' => 'passwordset'),
 array('password', 'compare', 'compareAttribute' => 'password_repeat'),
 array('username, password, password_repeat,loket', 'safe'),
 array('level', 'numerical', 'integerOnly'=>true),
 array('level', 'default', 'value'=>9, 'on'=>'insert'),
 // The following rule is used by search().
 // @todo Please remove those attributes that should not be searched.

 );
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'rel_jenis'=>array(self::BELONGS_TO, 'Loket', 'loket'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
   'id' => 'ID',
   'username' => 'Username',
   'password' => 'Password',
   'password_repeat' => 'Password Repeat',
   'level' => 'Level',
 );
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('username',$this->username,true);
		$criteria->compare('pwd_hash',$this->pwd_hash,true);
		$criteria->compare('level',$this->level);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return User the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	public function hash($value)
 	{
   return crypt($value,'');
	 }
	 /**
 * We need to call the encryption function whenever we store a password,
 * – on create and on update –
 * so we will overload the beforeSave function to do the hashing.
 */
protected function beforeSave()
{
 if (parent::beforeSave()) {
   if (!empty($this->password))
     $this->pwd_hash = $this->hash($this->password);

   /* contoh kalau ada tgl_masuk dan tgl keluar
   if ($this->isNewRecord)
     $this->tgl_masuk = new CDbExpression('NOW()');
 
   $this->tgl_update = new CDbExpression('NOW()');
   */

   return true;
 }
 return false;
}

public function check($value)
{
 $new_hash = crypt($value, $this->pwd_hash);
 
 if ($new_hash == $this->pwd_hash) {
   return true;
 }
 return false;
}
}
